/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.cim.provider.rs6k.indication.client;

import com.ibm.hsc.cim.provider.rs6k.indication.client.HSCEventHandler;
import java.io.Serializable;

public class HSCSubscription
implements Serializable {
    public static final int SUB_SEND_REQUEST = -1;
    public static final int SUB_FAILED = 0;
    public static final int SUB_SUCCESS = 1;
    private int mEvtType;
    private String mObjType;
    private int mSubId;
    private String mUserName;
    private String mPassword = null;
    private boolean mSubscription;
    private transient HSCEventHandler mEvtHandler;
    private String mAuthKey = null;

    public HSCSubscription(int n, String string, boolean bl, String string2, String string3, HSCEventHandler hSCEventHandler) {
        this.mEvtType = n;
        this.mObjType = string;
        this.mSubscription = bl;
        this.mUserName = string2;
        if (string3 != null) {
            this.mPassword = this.passEncoding(string3);
        }
        this.mSubId = -1;
        this.mEvtHandler = hSCEventHandler;
    }

    public String getAuthKey() {
        return this.mAuthKey;
    }

    public void setAuthKey(String string) {
        this.mAuthKey = string;
    }

    public HSCSubscription copy() {
        HSCSubscription hSCSubscription = new HSCSubscription(this.mEvtType, this.mObjType, this.mSubscription, this.mUserName, this.mPassword, this.mEvtHandler);
        hSCSubscription.setSubId(this.mSubId);
        return hSCSubscription;
    }

    public HSCEventHandler getHandler() {
        return this.mEvtHandler;
    }

    public int getEventType() {
        return this.mEvtType;
    }

    public String getObjectType() {
        return this.mObjType;
    }

    public boolean isSubscription() {
        return this.mSubscription;
    }

    public void setSubscription(boolean bl) {
        this.mSubscription = bl;
    }

    public String getUserName() {
        return this.mUserName;
    }

    public String getPassword() {
        if (this.mPassword != null) {
            return this.passDecoding(this.mPassword);
        }
        return null;
    }

    public int getSubId() {
        return this.mSubId;
    }

    public void setSubId(int n) {
        this.mSubId = n;
    }

    private String passEncoding(String string) {
        byte[] byArray = string.getBytes();
        for (int i = 0; i < byArray.length; ++i) {
            int n = i;
            byArray[n] = (byte)(byArray[n] + i * 2);
        }
        return new String(byArray);
    }

    private String passDecoding(String string) {
        byte[] byArray = string.getBytes();
        for (int i = 0; i < byArray.length; ++i) {
            int n = i;
            byArray[n] = (byte)(byArray[n] - i * 2);
        }
        return new String(byArray);
    }

    public String getEventKey() {
        return HSCSubscription.getEventKey(this.mEvtType, this.mObjType);
    }

    public static String getEventKey(int n, String string) {
        return string + "-" + n;
    }
}

